//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Diagnostics;

namespace WindowsForms
{
	/// <summary>
	/// Podsumowanie dla ProcessForm.
	/// </summary>
	public class ProcessForm : System.Windows.Forms.Form
	{
		private ProcessThreadCollection processThreadCollection;
		private System.Windows.Forms.Label processNamelabel;
		private System.Windows.Forms.TextBox processName;
		private System.Windows.Forms.Label basePriorityLabel;
		private System.Windows.Forms.TextBox basePriority;
		private System.Windows.Forms.Label idLabel;
		private System.Windows.Forms.TextBox id;
		private System.Windows.Forms.Label handleCountlabel;
		private System.Windows.Forms.TextBox handleCount;
		private System.Windows.Forms.Label maxWorkingSetLabel;
		private System.Windows.Forms.TextBox maxWorkingSet;
		private System.Windows.Forms.TextBox minWorkingSet;
		private System.Windows.Forms.Label minWorkingSetLabel;
		private System.Windows.Forms.TextBox nonPagedSystemMemory;
		private System.Windows.Forms.Label nonPagedSystemLabel;
		private System.Windows.Forms.TextBox workingSet;
		private System.Windows.Forms.Label workingSetLabel;
		private System.Windows.Forms.TextBox pagedSystemMemory;
		private System.Windows.Forms.Label pagedSystemMemoryLabel;
		private System.Windows.Forms.TextBox peakWorkingSet;
		private System.Windows.Forms.Label peakWorkingSetLabel;
		private System.Windows.Forms.TextBox pagedMemory;
		private System.Windows.Forms.Label pagedMemoryLabel;
		private System.Windows.Forms.TextBox peakPagedMemory;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label peakVirtualMemoryLabel;
		private System.Windows.Forms.TextBox virtualMemory;
		private System.Windows.Forms.Label virtualMemoryLabel;
		private System.Windows.Forms.TextBox peakVirtualMemory;
		private System.Windows.Forms.TextBox startTime;
		private System.Windows.Forms.Label startTimeLabel;
		private System.Windows.Forms.TextBox userProcessorTime;
		private System.Windows.Forms.Label userProcessorTimeLabel;
		private System.Windows.Forms.Label totalTimeLabel;
		private System.Windows.Forms.TextBox totalProcessorTime;
		private System.Windows.Forms.TabControl threadTabControl;
		private System.Windows.Forms.TabPage tabPage1;
		private System.Windows.Forms.Label threadCountLabel;
		private System.Windows.Forms.TextBox threadCount;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ProcessForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			//
			// TODO: Dodanie kodu konstruktora po wywoaniu InitializeComponent
			//
		}

		public string ProcessName
		{
			get
			{
				return processName.Text;
			}
			set
			{
				processName.Text = value;
			}
		}
		public int BasePriority
		{
			get
			{
				return Convert.ToInt32(basePriority.Text);
			}
			set
			{
				basePriority.Text = value.ToString("#,#");
			}
		}
		public int Id
		{
			get
			{
				return Convert.ToInt32(id.Text);
			}
			set
			{
				id.Text = value.ToString();
			}
		}
		public int HandleCount
		{
			get
			{
				return Convert.ToInt32(handleCount.Text);
			}
			set
			{
				handleCount.Text = value.ToString("#,#");
			}
		}
		public int MaxWorkingSet
		{
			get
			{
				return Convert.ToInt32(maxWorkingSet.Text);
			}
			set
			{
				maxWorkingSet.Text = value.ToString("#,#");
			}
		}
		public int MinWorkingSet
		{
			get
			{
				return Convert.ToInt32(minWorkingSet.Text);
			}
			set
			{
				minWorkingSet.Text = value.ToString("#,#");
			}
		}
		public int NonpagedSystemMemorySize
		{
			get
			{
				return Convert.ToInt32(nonPagedSystemMemory.Text);
			}
			set
			{
				nonPagedSystemMemory.Text = value.ToString("#,#");
			}
		}
		public int PagedSystemMemorySize
		{
			get
			{
				return Convert.ToInt32(pagedSystemMemory.Text);
			}
			set
			{
				pagedSystemMemory.Text = value.ToString("#,#");
			}
		}
		public int PeakWorkingSet
		{
			get
			{
				return Convert.ToInt32(peakWorkingSet.Text);
			}
			set
			{
				peakWorkingSet.Text = value.ToString("#,#");
			}
		}
		public int WorkingSet
		{
			get
			{
				return Convert.ToInt32(workingSet.Text);
			}
			set
			{
				workingSet.Text = value.ToString("#,#");
			}
		}
		public int PagedMemorySize
		{
			get
			{
				return Convert.ToInt32(pagedMemory.Text);
			}
			set
			{
				pagedMemory.Text = value.ToString("#,#");
			}
		}
		public int PeakPagedMemorySize
		{
			get
			{
				return Convert.ToInt32(peakPagedMemory.Text);
			}
			set
			{
				peakPagedMemory.Text = value.ToString("#,#");
			}
		}
		public int VirtualMemorySize
		{
			get
			{
				return Convert.ToInt32(virtualMemory.Text);
			}
			set
			{
				virtualMemory.Text = value.ToString("#,#");
			}
		}
		public int PeakVirtualMemorySize
		{
			get
			{
				return Convert.ToInt32(peakVirtualMemory.Text);
			}
			set
			{
				peakVirtualMemory.Text = value.ToString("#,#");
			}
		}
		public DateTime StartTime
		{
			get
			{
				return Convert.ToDateTime(startTime.Text);
			}
			set
			{
				startTime.Text = value.ToString();
			}
		}
		public TimeSpan UserProcessorTime
		{
			set
			{
				userProcessorTime.Text = value.ToString();
			}
		}
		public TimeSpan TotalProcessorTime
		{
			set
			{
				totalProcessorTime.Text = value.ToString();
			}
		}
		public ProcessThreadCollection Threads
		{
			set
			{
				processThreadCollection = value;
			}
		}
		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.processNamelabel = new System.Windows.Forms.Label();
			this.processName = new System.Windows.Forms.TextBox();
			this.basePriorityLabel = new System.Windows.Forms.Label();
			this.basePriority = new System.Windows.Forms.TextBox();
			this.idLabel = new System.Windows.Forms.Label();
			this.id = new System.Windows.Forms.TextBox();
			this.handleCountlabel = new System.Windows.Forms.Label();
			this.handleCount = new System.Windows.Forms.TextBox();
			this.maxWorkingSetLabel = new System.Windows.Forms.Label();
			this.maxWorkingSet = new System.Windows.Forms.TextBox();
			this.minWorkingSet = new System.Windows.Forms.TextBox();
			this.minWorkingSetLabel = new System.Windows.Forms.Label();
			this.nonPagedSystemMemory = new System.Windows.Forms.TextBox();
			this.nonPagedSystemLabel = new System.Windows.Forms.Label();
			this.workingSet = new System.Windows.Forms.TextBox();
			this.workingSetLabel = new System.Windows.Forms.Label();
			this.pagedSystemMemory = new System.Windows.Forms.TextBox();
			this.pagedSystemMemoryLabel = new System.Windows.Forms.Label();
			this.peakWorkingSet = new System.Windows.Forms.TextBox();
			this.peakWorkingSetLabel = new System.Windows.Forms.Label();
			this.pagedMemory = new System.Windows.Forms.TextBox();
			this.pagedMemoryLabel = new System.Windows.Forms.Label();
			this.peakPagedMemory = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.peakVirtualMemory = new System.Windows.Forms.TextBox();
			this.peakVirtualMemoryLabel = new System.Windows.Forms.Label();
			this.virtualMemory = new System.Windows.Forms.TextBox();
			this.virtualMemoryLabel = new System.Windows.Forms.Label();
			this.startTime = new System.Windows.Forms.TextBox();
			this.startTimeLabel = new System.Windows.Forms.Label();
			this.userProcessorTime = new System.Windows.Forms.TextBox();
			this.userProcessorTimeLabel = new System.Windows.Forms.Label();
			this.totalProcessorTime = new System.Windows.Forms.TextBox();
			this.totalTimeLabel = new System.Windows.Forms.Label();
			this.threadTabControl = new System.Windows.Forms.TabControl();
			this.tabPage1 = new System.Windows.Forms.TabPage();
			this.threadCountLabel = new System.Windows.Forms.Label();
			this.threadCount = new System.Windows.Forms.TextBox();
			this.threadTabControl.SuspendLayout();
			this.SuspendLayout();
			// 
			// processNamelabel
			// 
			this.processNamelabel.Location = new System.Drawing.Point(7, 15);
			this.processNamelabel.Name = "processNamelabel";
			this.processNamelabel.Size = new System.Drawing.Size(88, 15);
			this.processNamelabel.TabIndex = 0;
			this.processNamelabel.Text = "Nazwa procesu";
			// 
			// processName
			// 
			this.processName.Location = new System.Drawing.Point(102, 8);
			this.processName.Name = "processName";
			this.processName.ReadOnly = true;
			this.processName.Size = new System.Drawing.Size(110, 20);
			this.processName.TabIndex = 1;
			this.processName.Text = "";
			// 
			// basePriorityLabel
			// 
			this.basePriorityLabel.Location = new System.Drawing.Point(29, 76);
			this.basePriorityLabel.Name = "basePriorityLabel";
			this.basePriorityLabel.Size = new System.Drawing.Size(81, 15);
			this.basePriorityLabel.TabIndex = 2;
			this.basePriorityLabel.Text = "Bazowy priorytet";
			// 
			// basePriority
			// 
			this.basePriority.Location = new System.Drawing.Point(153, 68);
			this.basePriority.Name = "basePriority";
			this.basePriority.ReadOnly = true;
			this.basePriority.Size = new System.Drawing.Size(95, 20);
			this.basePriority.TabIndex = 3;
			this.basePriority.Text = "";
			this.basePriority.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// idLabel
			// 
			this.idLabel.Location = new System.Drawing.Point(29, 53);
			this.idLabel.Name = "idLabel";
			this.idLabel.Size = new System.Drawing.Size(81, 15);
			this.idLabel.TabIndex = 4;
			this.idLabel.Text = "Id";
			// 
			// id
			// 
			this.id.Location = new System.Drawing.Point(153, 45);
			this.id.Name = "id";
			this.id.ReadOnly = true;
			this.id.Size = new System.Drawing.Size(95, 20);
			this.id.TabIndex = 5;
			this.id.Text = "";
			this.id.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// handleCountlabel
			// 
			this.handleCountlabel.Location = new System.Drawing.Point(29, 98);
			this.handleCountlabel.Name = "handleCountlabel";
			this.handleCountlabel.Size = new System.Drawing.Size(81, 16);
			this.handleCountlabel.TabIndex = 6;
			this.handleCountlabel.Text = "Liczba uchwytw";
			// 
			// handleCount
			// 
			this.handleCount.Location = new System.Drawing.Point(153, 91);
			this.handleCount.Name = "handleCount";
			this.handleCount.ReadOnly = true;
			this.handleCount.Size = new System.Drawing.Size(95, 20);
			this.handleCount.TabIndex = 7;
			this.handleCount.Text = "";
			this.handleCount.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// maxWorkingSetLabel
			// 
			this.maxWorkingSetLabel.Location = new System.Drawing.Point(29, 121);
			this.maxWorkingSetLabel.Name = "maxWorkingSetLabel";
			this.maxWorkingSetLabel.Size = new System.Drawing.Size(103, 15);
			this.maxWorkingSetLabel.TabIndex = 8;
			this.maxWorkingSetLabel.Text = "Maks. zestaw roboczy";
			// 
			// maxWorkingSet
			// 
			this.maxWorkingSet.Location = new System.Drawing.Point(153, 114);
			this.maxWorkingSet.Name = "maxWorkingSet";
			this.maxWorkingSet.ReadOnly = true;
			this.maxWorkingSet.Size = new System.Drawing.Size(95, 20);
			this.maxWorkingSet.TabIndex = 9;
			this.maxWorkingSet.Text = "";
			this.maxWorkingSet.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// minWorkingSet
			// 
			this.minWorkingSet.Location = new System.Drawing.Point(153, 136);
			this.minWorkingSet.Name = "minWorkingSet";
			this.minWorkingSet.ReadOnly = true;
			this.minWorkingSet.Size = new System.Drawing.Size(95, 20);
			this.minWorkingSet.TabIndex = 11;
			this.minWorkingSet.Text = "";
			this.minWorkingSet.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// minWorkingSetLabel
			// 
			this.minWorkingSetLabel.Location = new System.Drawing.Point(29, 144);
			this.minWorkingSetLabel.Name = "minWorkingSetLabel";
			this.minWorkingSetLabel.Size = new System.Drawing.Size(103, 15);
			this.minWorkingSetLabel.TabIndex = 10;
			this.minWorkingSetLabel.Text = "Min. zestaw roboczy";
			// 
			// nonPagedSystemMemory
			// 
			this.nonPagedSystemMemory.Location = new System.Drawing.Point(153, 204);
			this.nonPagedSystemMemory.Name = "nonPagedSystemMemory";
			this.nonPagedSystemMemory.ReadOnly = true;
			this.nonPagedSystemMemory.Size = new System.Drawing.Size(95, 20);
			this.nonPagedSystemMemory.TabIndex = 13;
			this.nonPagedSystemMemory.Text = "";
			this.nonPagedSystemMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// nonPagedSystemLabel
			// 
			this.nonPagedSystemLabel.Location = new System.Drawing.Point(29, 212);
			this.nonPagedSystemLabel.Name = "nonPagedSystemLabel";
			this.nonPagedSystemLabel.Size = new System.Drawing.Size(110, 15);
			this.nonPagedSystemLabel.TabIndex = 12;
			this.nonPagedSystemLabel.Text = "System bez stronic";
			// 
			// workingSet
			// 
			this.workingSet.Location = new System.Drawing.Point(153, 182);
			this.workingSet.Name = "workingSet";
			this.workingSet.ReadOnly = true;
			this.workingSet.Size = new System.Drawing.Size(95, 20);
			this.workingSet.TabIndex = 15;
			this.workingSet.Text = "";
			this.workingSet.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// workingSetLabel
			// 
			this.workingSetLabel.Location = new System.Drawing.Point(29, 189);
			this.workingSetLabel.Name = "workingSetLabel";
			this.workingSetLabel.Size = new System.Drawing.Size(103, 15);
			this.workingSetLabel.TabIndex = 14;
			this.workingSetLabel.Text = "Zestaw roboczy";
			// 
			// pagedSystemMemory
			// 
			this.pagedSystemMemory.Location = new System.Drawing.Point(153, 227);
			this.pagedSystemMemory.Name = "pagedSystemMemory";
			this.pagedSystemMemory.ReadOnly = true;
			this.pagedSystemMemory.Size = new System.Drawing.Size(95, 20);
			this.pagedSystemMemory.TabIndex = 17;
			this.pagedSystemMemory.Text = "";
			this.pagedSystemMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// pagedSystemMemoryLabel
			// 
			this.pagedSystemMemoryLabel.Location = new System.Drawing.Point(29, 235);
			this.pagedSystemMemoryLabel.Name = "pagedSystemMemoryLabel";
			this.pagedSystemMemoryLabel.Size = new System.Drawing.Size(110, 15);
			this.pagedSystemMemoryLabel.TabIndex = 16;
			this.pagedSystemMemoryLabel.Text = "System stronicowany";
			// 
			// peakWorkingSet
			// 
			this.peakWorkingSet.Location = new System.Drawing.Point(153, 159);
			this.peakWorkingSet.Name = "peakWorkingSet";
			this.peakWorkingSet.ReadOnly = true;
			this.peakWorkingSet.Size = new System.Drawing.Size(95, 20);
			this.peakWorkingSet.TabIndex = 19;
			this.peakWorkingSet.Text = "";
			this.peakWorkingSet.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// peakWorkingSetLabel
			// 
			this.peakWorkingSetLabel.Location = new System.Drawing.Point(29, 167);
			this.peakWorkingSetLabel.Name = "peakWorkingSetLabel";
			this.peakWorkingSetLabel.Size = new System.Drawing.Size(103, 15);
			this.peakWorkingSetLabel.TabIndex = 18;
			this.peakWorkingSetLabel.Text = "Szczytowy zestaw roboczy";
			// 
			// pagedMemory
			// 
			this.pagedMemory.Location = new System.Drawing.Point(153, 250);
			this.pagedMemory.Name = "pagedMemory";
			this.pagedMemory.ReadOnly = true;
			this.pagedMemory.Size = new System.Drawing.Size(95, 20);
			this.pagedMemory.TabIndex = 21;
			this.pagedMemory.Text = "";
			this.pagedMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// pagedMemoryLabel
			// 
			this.pagedMemoryLabel.Location = new System.Drawing.Point(29, 257);
			this.pagedMemoryLabel.Name = "pagedMemoryLabel";
			this.pagedMemoryLabel.Size = new System.Drawing.Size(110, 16);
			this.pagedMemoryLabel.TabIndex = 20;
			this.pagedMemoryLabel.Text = "Stronicowany";
			// 
			// peakPagedMemory
			// 
			this.peakPagedMemory.Location = new System.Drawing.Point(153, 273);
			this.peakPagedMemory.Name = "peakPagedMemory";
			this.peakPagedMemory.ReadOnly = true;
			this.peakPagedMemory.Size = new System.Drawing.Size(95, 20);
			this.peakPagedMemory.TabIndex = 23;
			this.peakPagedMemory.Text = "";
			this.peakPagedMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(29, 280);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(110, 15);
			this.label2.TabIndex = 22;
			this.label2.Text = "Szczytowy stronicowany";
			// 
			// peakVirtualMemory
			// 
			this.peakVirtualMemory.Location = new System.Drawing.Point(153, 318);
			this.peakVirtualMemory.Name = "peakVirtualMemory";
			this.peakVirtualMemory.ReadOnly = true;
			this.peakVirtualMemory.Size = new System.Drawing.Size(95, 20);
			this.peakVirtualMemory.TabIndex = 27;
			this.peakVirtualMemory.Text = "";
			this.peakVirtualMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// peakVirtualMemoryLabel
			// 
			this.peakVirtualMemoryLabel.Location = new System.Drawing.Point(29, 326);
			this.peakVirtualMemoryLabel.Name = "peakVirtualMemoryLabel";
			this.peakVirtualMemoryLabel.Size = new System.Drawing.Size(110, 15);
			this.peakVirtualMemoryLabel.TabIndex = 26;
			this.peakVirtualMemoryLabel.Text = "Szczytowy wirtualny";
			// 
			// virtualMemory
			// 
			this.virtualMemory.Location = new System.Drawing.Point(153, 295);
			this.virtualMemory.Name = "virtualMemory";
			this.virtualMemory.ReadOnly = true;
			this.virtualMemory.Size = new System.Drawing.Size(95, 20);
			this.virtualMemory.TabIndex = 25;
			this.virtualMemory.Text = "";
			this.virtualMemory.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// virtualMemoryLabel
			// 
			this.virtualMemoryLabel.Location = new System.Drawing.Point(29, 303);
			this.virtualMemoryLabel.Name = "virtualMemoryLabel";
			this.virtualMemoryLabel.Size = new System.Drawing.Size(110, 15);
			this.virtualMemoryLabel.TabIndex = 24;
			this.virtualMemoryLabel.Text = "Wirtualny";
			// 
			// startTime
			// 
			this.startTime.Location = new System.Drawing.Point(124, 341);
			this.startTime.Name = "startTime";
			this.startTime.ReadOnly = true;
			this.startTime.Size = new System.Drawing.Size(124, 20);
			this.startTime.TabIndex = 29;
			this.startTime.Text = "";
			this.startTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// startTimeLabel
			// 
			this.startTimeLabel.Location = new System.Drawing.Point(29, 348);
			this.startTimeLabel.Name = "startTimeLabel";
			this.startTimeLabel.Size = new System.Drawing.Size(66, 16);
			this.startTimeLabel.TabIndex = 28;
			this.startTimeLabel.Text = "Czas pocztkowy";
			// 
			// userProcessorTime
			// 
			this.userProcessorTime.Location = new System.Drawing.Point(124, 364);
			this.userProcessorTime.Name = "userProcessorTime";
			this.userProcessorTime.ReadOnly = true;
			this.userProcessorTime.Size = new System.Drawing.Size(124, 20);
			this.userProcessorTime.TabIndex = 31;
			this.userProcessorTime.Text = "";
			this.userProcessorTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// userProcessorTimeLabel
			// 
			this.userProcessorTimeLabel.Location = new System.Drawing.Point(29, 371);
			this.userProcessorTimeLabel.Name = "userProcessorTimeLabel";
			this.userProcessorTimeLabel.Size = new System.Drawing.Size(73, 15);
			this.userProcessorTimeLabel.TabIndex = 30;
			this.userProcessorTimeLabel.Text = "Czas uytkownika";
			// 
			// totalProcessorTime
			// 
			this.totalProcessorTime.Location = new System.Drawing.Point(124, 386);
			this.totalProcessorTime.Name = "totalProcessorTime";
			this.totalProcessorTime.ReadOnly = true;
			this.totalProcessorTime.Size = new System.Drawing.Size(124, 20);
			this.totalProcessorTime.TabIndex = 33;
			this.totalProcessorTime.Text = "";
			this.totalProcessorTime.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// totalTimeLabel
			// 
			this.totalTimeLabel.Location = new System.Drawing.Point(29, 394);
			this.totalTimeLabel.Name = "totalTimeLabel";
			this.totalTimeLabel.Size = new System.Drawing.Size(73, 15);
			this.totalTimeLabel.TabIndex = 32;
			this.totalTimeLabel.Text = "Cakowity czas";
			// 
			// threadTabControl
			// 
			this.threadTabControl.Controls.AddRange(new System.Windows.Forms.Control[] {
																						   this.tabPage1});
			this.threadTabControl.Location = new System.Drawing.Point(256, 48);
			this.threadTabControl.Name = "threadTabControl";
			this.threadTabControl.SelectedIndex = 0;
			this.threadTabControl.Size = new System.Drawing.Size(304, 360);
			this.threadTabControl.TabIndex = 34;
			// 
			// tabPage1
			// 
			this.tabPage1.Location = new System.Drawing.Point(4, 22);
			this.tabPage1.Name = "tabPage1";
			this.tabPage1.TabIndex = 0;
			this.tabPage1.Text = "1";
			// 
			// threadCountLabel
			// 
			this.threadCountLabel.Location = new System.Drawing.Point(256, 16);
			this.threadCountLabel.Name = "threadCountLabel";
			this.threadCountLabel.Size = new System.Drawing.Size(81, 15);
			this.threadCountLabel.TabIndex = 35;
			this.threadCountLabel.Text = "Liczba wtkw";
			// 
			// threadCount
			// 
			this.threadCount.Location = new System.Drawing.Point(352, 8);
			this.threadCount.Name = "threadCount";
			this.threadCount.ReadOnly = true;
			this.threadCount.Size = new System.Drawing.Size(95, 20);
			this.threadCount.TabIndex = 36;
			this.threadCount.Text = "";
			this.threadCount.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// ProcessForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(568, 424);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.threadCount,
																		  this.threadCountLabel,
																		  this.threadTabControl,
																		  this.totalProcessorTime,
																		  this.totalTimeLabel,
																		  this.userProcessorTime,
																		  this.userProcessorTimeLabel,
																		  this.startTime,
																		  this.startTimeLabel,
																		  this.peakVirtualMemory,
																		  this.peakVirtualMemoryLabel,
																		  this.virtualMemory,
																		  this.virtualMemoryLabel,
																		  this.peakPagedMemory,
																		  this.label2,
																		  this.pagedMemory,
																		  this.pagedMemoryLabel,
																		  this.peakWorkingSet,
																		  this.peakWorkingSetLabel,
																		  this.pagedSystemMemory,
																		  this.pagedSystemMemoryLabel,
																		  this.workingSet,
																		  this.workingSetLabel,
																		  this.nonPagedSystemMemory,
																		  this.nonPagedSystemLabel,
																		  this.minWorkingSet,
																		  this.minWorkingSetLabel,
																		  this.maxWorkingSet,
																		  this.maxWorkingSetLabel,
																		  this.handleCount,
																		  this.handleCountlabel,
																		  this.id,
																		  this.idLabel,
																		  this.basePriority,
																		  this.basePriorityLabel,
																		  this.processName,
																		  this.processNamelabel});
			this.Name = "ProcessForm";
			this.Text = "ProcessForm";
			this.Load += new System.EventHandler(this.ProcessForm_Load);
			this.threadTabControl.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		private void ProcessForm_Load(object sender, System.EventArgs e)
		{
			int count = 0;
			threadTabControl.SuspendLayout();
			threadTabControl.Controls.Clear();
			threadCount.Text = processThreadCollection.Count.ToString();
			foreach(ProcessThread pt in processThreadCollection)
			{
				ThreadInfoPage tp = new ThreadInfoPage();
				tp.TabName = count.ToString();
				tp.Id = pt.Id;
				tp.BasePriority = pt.BasePriority;
				tp.CurrentPriority = pt.CurrentPriority;
				tp.PriorityLevel = pt.PriorityLevel;
				tp.StartAddress = pt.StartAddress;
				tp.StartTime = pt.StartTime;
				tp.ThreadState = pt.ThreadState;
				if(pt.ThreadState == ThreadState.Wait)
					tp.WaitReason = pt.WaitReason;
				tp.UserProcessorTime = pt.UserProcessorTime;
				tp.TotalProcessorTime = pt.TotalProcessorTime;
				tp.PrivilegedProcessorTime = pt.PrivilegedProcessorTime;
				threadTabControl.Controls.Add(tp);
				count++;
			}
			threadTabControl.ResumeLayout(false);
		}
	}
}
